%%  ջ
warning off             % رձϢ
close all               % رտͼ
clear                   % ձ
clc                     % 

%%  
res = xlsread('ݼ.xlsx');

%%  ѵͲԼ
temp = randperm(103);

P_train = res(temp(1: 80), 1: 7)';
T_train = res(temp(1: 80), 8)';
M = size(P_train, 2);

P_test = res(temp(81: end), 1: 7)';
T_test = res(temp(81: end), 8)';
N = size(P_test, 2);

%%  ݹһ
[P_train, ps_input] = mapminmax(P_train, 0, 1);
P_test = mapminmax('apply', P_test, ps_input);

[t_train, ps_output] = mapminmax(T_train, 0, 1);
t_test = mapminmax('apply', T_test, ps_output);

%%  ƽ
P_train =  double(reshape(P_train, 7, 1, 1, M));
P_test  =  double(reshape(P_test , 7, 1, 1, N));

t_train = t_train';
t_test  = t_test' ;

%%  ݸʽת
for i = 1 : M
    p_train{i, 1} = P_train(:, :, 1, i);
end

for i = 1 : N
    p_test{i, 1}  = P_test( :, :, 1, i);
end

%%  ģ
layers = [
    sequenceInputLayer(7)               % 
    
    lstmLayer(4, 'OutputMode', 'last')  % LSTM
    reluLayer                           % Relu
    
    fullyConnectedLayer(1)              % ȫӲ
    regressionLayer];                   % ع
 
%%  
options = trainingOptions('adam', ...      % Adam ݶ½㷨
    'MaxEpochs', 1500, ...                 % 
    'InitialLearnRate', 0.01, ...          % ʼѧϰΪ 0.01
    'LearnRateSchedule', 'piecewise', ...  % ѧϰ½
    'LearnRateDropFactor', 0.1, ...        % ѧϰ½
    'LearnRateDropPeriod', 1200, ...       %  1200 ѵ ѧϰΪ 0.01 * 0.1
    'Shuffle', 'every-epoch', ...          % ÿѵݼ
    'Plots', 'training-progress', ...      % 
    'Verbose', false);

%%  ѵģ
net = trainNetwork(p_train, t_train, layers, options);

%%  Ԥ
t_sim1 = predict(net, p_train);
t_sim2 = predict(net, p_test );

%%  ݷһ
T_sim1 = mapminmax('reverse', t_sim1, ps_output);
T_sim2 = mapminmax('reverse', t_sim2, ps_output);

%%  
error1 = sqrt(sum((T_sim1' - T_train).^2) ./ M);
error2 = sqrt(sum((T_sim2' - T_test ).^2) ./ N);

%%  鿴ṹ
analyzeNetwork(net)

%%  ͼ
figure
plot(1: M, T_train, 'r-*', 1: M, T_sim1, 'b-o', 'LineWidth', 1)
legend('ʵֵ', 'Ԥֵ')
xlabel('Ԥ')
ylabel('Ԥ')
string = {'ѵԤԱ'; ['RMSE=' num2str(error1)]};
title(string)
xlim([1, M])
grid

figure
plot(1: N, T_test, 'r-*', 1: N, T_sim2, 'b-o', 'LineWidth', 1)
legend('ʵֵ', 'Ԥֵ')
xlabel('Ԥ')
ylabel('Ԥ')
string = {'ԼԤԱ'; ['RMSE=' num2str(error2)]};
title(string)
xlim([1, N])
grid

%%  ָ
% R2
R1 = 1 - norm(T_train - T_sim1')^2 / norm(T_train - mean(T_train))^2;
R2 = 1 - norm(T_test  - T_sim2')^2 / norm(T_test  - mean(T_test ))^2;

disp(['ѵݵR2Ϊ', num2str(R1)])
disp(['ԼݵR2Ϊ', num2str(R2)])

% MAE
mae1 = sum(abs(T_sim1' - T_train)) ./ M ;
mae2 = sum(abs(T_sim2' - T_test )) ./ N ;

disp(['ѵݵMAEΪ', num2str(mae1)])
disp(['ԼݵMAEΪ', num2str(mae2)])

% MBE
mbe1 = sum(T_sim1' - T_train) ./ M ;
mbe2 = sum(T_sim2' - T_test ) ./ N ;

disp(['ѵݵMBEΪ', num2str(mbe1)])
disp(['ԼݵMBEΪ', num2str(mbe2)])

%%  ɢͼ
sz = 25;
c = 'b';

figure
scatter(T_train, T_sim1, sz, c)
hold on
plot(xlim, ylim, '--k')
xlabel('ѵʵֵ');
ylabel('ѵԤֵ');
xlim([min(T_train) max(T_train)])
ylim([min(T_sim1) max(T_sim1)])
title('ѵԤֵ vs. ѵʵֵ')

figure
scatter(T_test, T_sim2, sz, c)
hold on
plot(xlim, ylim, '--k')
xlabel('Լʵֵ');
ylabel('ԼԤֵ');
xlim([min(T_test) max(T_test)])
ylim([min(T_sim2) max(T_sim2)])
title('ԼԤֵ vs. Լʵֵ')